/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.theme.VWWorkplaceXTTheme;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class VWBaseCore
implements ActionListener {
    public static final String ACMD_LOOK_AND_FEEL = "Look and Feel";
    private static final String LOOK_AND_FEEL_CLASS_NAME_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String LOOK_AND_FEEL_CLASS_NAME_WINDOWS_CLASSIC = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    private static final String LOOK_AND_FEEL_CLASS_NAME_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String LOOK_AND_FEEL_DISPLAY_NAME_METAL = "Metal";
    private static final String LOOK_AND_FEEL_DISPLAY_NAME_WINDOWS_CLASSIC = "Windows Classic";
    private static final String LOOK_AND_FEEL_DISPLAY_NAME_WINDOWS = "Windows";
    protected VWSessionInfo m_vwSessionInfo = null;
    private boolean m_bInitialized = false;
    protected JMenu m_settingsMenu = null;
    protected JMenu m_lookAndFeelMenu = null;
    protected Vector<JRadioButtonMenuItem> m_lfMenuItems = null;
    protected ButtonGroup m_lfButtonGroup = null;
    private UIManager.LookAndFeelInfo[] m_lookAndFeelInfoList = null;
    private UIManager.LookAndFeelInfo m_currentLookAndFeelInfo = null;

    public VWBaseCore() {
        this(false);
    }

    public VWBaseCore(boolean commandLineMode) {
        if (!commandLineMode) {
            this.m_lookAndFeelInfoList = UIManager.getInstalledLookAndFeels();
        }
    }

    public JMenu getSettingsMenu(JMenuBar parentMenuBar) {
        if (this.m_lookAndFeelInfoList != null && this.m_lookAndFeelInfoList.length > 1) {
            this.m_settingsMenu = VWStringUtils.getMenuUsingString(VWResource.s_settings_withHK);
            this.m_settingsMenu.getAccessibleContext().setAccessibleName(VWResource.s_settings_withHK);
            this.m_settingsMenu.getAccessibleContext().setAccessibleDescription(VWResource.s_settings_withHK);
            this.m_settingsMenu.getAccessibleContext().setAccessibleParent(parentMenuBar);
            this.m_lookAndFeelMenu = VWStringUtils.getMenuUsingString(VWResource.s_lookAndFeel_withHK);
            this.m_settingsMenu.add(this.m_lookAndFeelMenu);
            this.m_lookAndFeelMenu.getAccessibleContext().setAccessibleName(VWResource.s_lookAndFeel_withHK);
            this.m_lookAndFeelMenu.getAccessibleContext().setAccessibleDescription(VWResource.s_lookAndFeel_withHK);
            this.m_lookAndFeelMenu.getAccessibleContext().setAccessibleParent(this.m_settingsMenu);
            this.m_lfMenuItems = new Vector();
            this.m_lfButtonGroup = new ButtonGroup();
            int nWindowsLookAndFeelIndex = -1;
            boolean bFoundWindowClassic = false;
            for (int nIndex = 0; nIndex < this.m_lookAndFeelInfoList.length; ++nIndex) {
                String name = this.m_lookAndFeelInfoList[nIndex].getName();
                String className = this.m_lookAndFeelInfoList[nIndex].getClassName();
                if (VWStringUtils.compare(className, LOOK_AND_FEEL_CLASS_NAME_METAL) == 0) {
                    this.createLookAndFeelMenuItem(name);
                    continue;
                }
                if (VWStringUtils.compare(className, LOOK_AND_FEEL_CLASS_NAME_WINDOWS_CLASSIC) == 0 || VWStringUtils.compare(name, LOOK_AND_FEEL_DISPLAY_NAME_WINDOWS_CLASSIC) == 0) {
                    this.createLookAndFeelMenuItem(name);
                    bFoundWindowClassic = true;
                    continue;
                }
                if (VWStringUtils.compare(className, LOOK_AND_FEEL_CLASS_NAME_WINDOWS) != 0 && VWStringUtils.compare(name, LOOK_AND_FEEL_DISPLAY_NAME_WINDOWS) != 0) continue;
                nWindowsLookAndFeelIndex = nIndex;
            }
            if (!bFoundWindowClassic && nWindowsLookAndFeelIndex >= 0) {
                String name = this.m_lookAndFeelInfoList[nWindowsLookAndFeelIndex].getName();
                this.createLookAndFeelMenuItem(name);
            }
            if (this.m_lfMenuItems != null && this.m_currentLookAndFeelInfo != null) {
                for (int nMenuIndex = 0; nMenuIndex < this.m_lfMenuItems.size(); ++nMenuIndex) {
                    JMenuItem menuItem = this.m_lfMenuItems.elementAt(nMenuIndex);
                    if (VWStringUtils.compare(menuItem.getText(), this.m_currentLookAndFeelInfo.getName()) != 0) continue;
                    menuItem.setSelected(true);
                    break;
                }
            }
            return this.m_settingsMenu;
        }
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (VWStringUtils.compare(event.getActionCommand(), ACMD_LOOK_AND_FEEL) == 0 && eventSource != null && eventSource instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)eventSource;
            this.performLookAndFeelAction(menuItem.getText());
        }
    }

    protected void init(VWSessionInfo sessionInfo) {
        this.m_vwSessionInfo = sessionInfo;
        try {
            VWUserInfo userInfo;
            String preferredDisplayName;
            String lfDisplayName = LOOK_AND_FEEL_DISPLAY_NAME_METAL;
            if (this.m_currentLookAndFeelInfo != null) {
                lfDisplayName = this.m_currentLookAndFeelInfo.getName();
            } else if (this.m_vwSessionInfo.getSession() != null && (preferredDisplayName = (String)(userInfo = this.m_vwSessionInfo.getSession().fetchCurrentUserInfo()).getFieldValue("look_and_feel")) != null) {
                lfDisplayName = preferredDisplayName;
            }
            this.performLookAndFeelAction(lfDisplayName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performLookAndFeelAction(String lfDisplayName) {
        if (lfDisplayName != null && lfDisplayName.trim().length() > 0 && this.m_lookAndFeelInfoList != null && this.m_lookAndFeelInfoList.length > 1) {
            for (int nIndex = 0; nIndex < this.m_lookAndFeelInfoList.length; ++nIndex) {
                if (this.m_lookAndFeelInfoList[nIndex] == null || VWStringUtils.compare(this.m_lookAndFeelInfoList[nIndex].getName(), lfDisplayName) != 0) continue;
                try {
                    if (VWStringUtils.compare(this.m_lookAndFeelInfoList[nIndex].getClassName(), LOOK_AND_FEEL_CLASS_NAME_METAL) == 0) {
                        VWWorkplaceXTTheme theme = new VWWorkplaceXTTheme();
                        MetalLookAndFeel.setCurrentTheme(theme);
                    }
                    UIManager.setLookAndFeel(this.m_lookAndFeelInfoList[nIndex].getClassName());
                    this.m_currentLookAndFeelInfo = this.m_lookAndFeelInfoList[nIndex];
                    if (this.m_vwSessionInfo != null) {
                        Frame appFrame = this.m_vwSessionInfo.getParentFrame();
                        if (appFrame != null) {
                            SwingUtilities.updateComponentTreeUI(appFrame);
                            Window[] windows = appFrame.getOwnedWindows();
                            if (windows != null) {
                                for (int j = 0; j < windows.length; ++j) {
                                    SwingUtilities.updateComponentTreeUI(windows[j]);
                                }
                            }
                            if (this.m_bInitialized) {
                                appFrame.pack();
                            }
                        }
                        VWUserInfo userInfo = this.m_vwSessionInfo.getSession().fetchCurrentUserInfo();
                        userInfo.setFieldValue("look_and_feel", this.m_lookAndFeelInfoList[nIndex].getName());
                        userInfo.save();
                    }
                    this.m_bInitialized = true;
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    protected void performInitialRefresh() {
        if (this.m_vwSessionInfo == null) {
            return;
        }
        try {
            Locale browserLocale = this.m_vwSessionInfo.getBrowserLocale();
            if (browserLocale != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(browserLocale);
                Frame appFrame = this.m_vwSessionInfo.getParentFrame();
                if (appFrame != null && compOrientation != null) {
                    appFrame.applyComponentOrientation(compOrientation);
                    Window[] windows = appFrame.getOwnedWindows();
                    if (windows != null) {
                        for (int j = 0; j < windows.length; ++j) {
                            windows[j].applyComponentOrientation(compOrientation);
                        }
                    }
                    appFrame.setPreferredSize(appFrame.getSize());
                    appFrame.pack();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_vwSessionInfo.getParentContainer() != null) {
            this.m_vwSessionInfo.getParentContainer().invalidate();
            this.m_vwSessionInfo.getParentContainer().validate();
            this.m_vwSessionInfo.getParentContainer().repaint();
        }
    }

    protected void releaseResources() {
        int nIndex;
        if (this.m_lookAndFeelInfoList != null) {
            for (nIndex = 0; nIndex < this.m_lookAndFeelInfoList.length; ++nIndex) {
                this.m_lookAndFeelInfoList[nIndex] = null;
            }
            this.m_lookAndFeelInfoList = null;
        }
        if (this.m_lookAndFeelMenu != null) {
            this.m_lookAndFeelMenu.removeAll();
            this.m_lookAndFeelMenu = null;
        }
        if (this.m_lfButtonGroup != null) {
            if (this.m_lfMenuItems != null) {
                for (nIndex = 0; nIndex < this.m_lfMenuItems.size(); ++nIndex) {
                    JMenuItem menuItem = this.m_lfMenuItems.elementAt(nIndex);
                    this.m_lfButtonGroup.remove(menuItem);
                }
                this.m_lfMenuItems.removeAllElements();
            }
            this.m_lfMenuItems = null;
            this.m_lfButtonGroup = null;
        }
        if (this.m_settingsMenu != null) {
            this.m_settingsMenu.removeAll();
            this.m_settingsMenu = null;
        }
        this.m_vwSessionInfo = null;
    }

    private void createLookAndFeelMenuItem(String name) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(name);
        menuItem.setMnemonic(name.charAt(0));
        this.m_lookAndFeelMenu.add(menuItem);
        AccessibleContext accessible_context = menuItem.getAccessibleContext();
        AccessibleRelationSet relationSet = accessible_context.getAccessibleRelationSet();
        AccessibleRelation grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, this.m_lfButtonGroup);
        VWAccessibilityHelper.setAccessibility(menuItem, this.m_lookAndFeelMenu, name, name);
        relationSet.add(grouped);
        this.m_lfButtonGroup.add(menuItem);
        this.m_lfMenuItems.addElement(menuItem);
        menuItem.setActionCommand(ACMD_LOOK_AND_FEEL);
        menuItem.addActionListener(this);
        menuItem.getAccessibleContext().setAccessibleName(name);
        menuItem.getAccessibleContext().setAccessibleDescription(name);
        menuItem.getAccessibleContext().setAccessibleParent(this.m_lookAndFeelMenu);
    }
}

